
/*
* This file is part of sso-autologin
*
* Copyright (C) 2009 Nokia Corporation. All rights reserved.
*
* Contact: Lucian Horga <ext-lucian.horga@nokia.com>
* Contact: Andrei Laperie <Andrei.Laperie@nokia.com>
*
* This software, including documentation, is protected by copyright
* controlled by Nokia Corporation. All rights are reserved.  Copying,
* including reproducing, storing, adapting or translating, any or all
* of this material requires the prior written consent of Nokia
* Corporation.  This material also contains confidential information
* which may not be disclosed to others without the prior written
* consent of Nokia.
*/

const nsISupports = Components.interfaces.nsISupports;
const nsIObserver = Components.interfaces.nsIObserver;
const nsISupportsWeakReference = Components.interfaces.nsISupportsWeakReference;
const nsIWebProgressListener = Components.interfaces.nsIWebProgressListener;

const CLASS_ID = Components.ID("ce402fde-cb5f-4d5f-a645-8b16b86d6004");
const CLASS_NAME = "SSOAutologin for MicroB";
const CONTRACT_ID = "@mozilla.org/ssoautologin;1";

// This is the constructor.
function ssoautologin() {
  this.wrappedJSObject = this;
}

// This is the implementation of the component.
ssoautologin.prototype = {
  // for nsISupports
  QueryInterface: function(aIID)                // add any other interfaces you support here
  {
    if (aIID.equals(nsIObserver))               // db242e01-e4d9-11d2-9dde-000064657374
      return this;

    if (aIID.equals(nsIWebProgressListener))    // 570F39D1-EFD0-11d3-B093-00A024FFC08C
      return this;

    if (aIID.equals(nsISupportsWeakReference))  // 9188bc85-f92e-11d2-81ef-0060083a0bcf
      return this;

    if (aIID.equals(nsISupports))               // 00000000-0000-0000-c000-000000000046
      return this;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  // nsIObserver
  observe: function(aSubject, aTopic, aData) {
      try {
        var XPCOMController = Components.classes["@browser.garage.maemo.org/Ssoautologin/SsoautologinComponent;1"]
                              .getService(Components.interfaces.microbISsoautologinComponent);
      } 
      catch(err) {
        this.customAlert(err);
        return;
      }

      if (aTopic == "app-startup") 
      {
        var observerService = Components.classes["@mozilla.org/observer-service;1"]
                              .getService(Components.interfaces.nsIObserverService);
        observerService.addObserver(this, "domwindowopened", false);

        docLoaderSvc = Components.classes["@mozilla.org/docloaderservice;1"].getService(Components.interfaces.nsIWebProgress);
        docLoaderSvc.addProgressListener(this, Components.interfaces.nsIWebProgress.NOTIFY_ALL);
        var loader = Components.classes['@mozilla.org/moz/jssubscript-loader;1']
                              .getService(Components.interfaces.mozIJSSubScriptLoader);
        loader.loadSubScript('chrome://ssoautologin/content/ssoautologin.js');
      }
  },

  domContentLoaded: function(e) {
    SSOAutologinScript.onLoad(e);
  },

  onContentSubmit: function(e) {
    SSOAutologinScript.onSubmit(e);
  },

  // nsIWebProgressListener
  onStateChange: function onStateChange(aWebProgress, aRequest, aStateFlags, aStatus)
  {
    var curWindow = aWebProgress.DOMWindow;
    try {
	var win = aRequest.loadGroup.notificationCallbacks.getInterface(Components.interfaces.nsIDOMWindow);	
    }
    catch(err) {
	return;
    }

    if (aStateFlags & Components.interfaces.nsIWebProgressListener.STATE_IS_REQUEST &&
        aStateFlags & Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT) 
    {
	  listen(win, "DOMContentLoaded", hitch(this, "domContentLoaded"));
//	  listen(win, "submit", hitch(this, "onContentSubmit"));
          listen(win, "click", hitch(this, "onContentSubmit"));
    }
  },

  onProgressChange: function onProgressChange(wp, r, csp, msp, ctp, mtp) {},
  onLocationChange: function onLocationChange(wp, r, l) {},
  onStatusChange: function onStatusChange(wp, r, s, m) {},
  onSecurityChange: function onSecurityChange(wp, r, s) {}
}

function hitch(obj, meth) {
  return function() { return obj[meth].apply(obj, arguments); }
}

function listen(source, event, listener, opt_capture) {
  Components.lookupMethod(source, "addEventListener")(
                          event, listener, opt_capture);
}

var ssoautologinFactory = {
  singleton: null,
  createInstance: function (aOuter, aIID)
  {
    if (aOuter != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;
    if (this.singleton == null)
      this.singleton = new ssoautologin();
    return this.singleton.QueryInterface(aIID);
  }
};

var ssoautologinModule = {
  registerSelf: function(aCompMgr, aFileSpec, aLocation, aType)
  {
    aCompMgr = aCompMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
    aCompMgr.registerFactoryLocation(CLASS_ID, CLASS_NAME, CONTRACT_ID, aFileSpec, aLocation, aType);

    var catman = Components.classes["@mozilla.org/categorymanager;1"]
                           .getService(Components.interfaces.nsICategoryManager);
    catman.addCategoryEntry("app-startup", CLASS_NAME,
                            CONTRACT_ID, true, true);
  },

  unregisterSelf: function(aCompMgr, aLocation, aType)
  {
    aCompMgr = aCompMgr.QueryInterface(Components.interfaces.nsIComponentRegistrar);
    aCompMgr.unregisterFactoryLocation(CLASS_ID, aLocation);

    var catman = Components.classes["@mozilla.org/categorymanager;1"]
                           .getService(Components.interfaces.nsICategoryManager);
    catman.deleteCategoryEntry("app-startup", CONTRACT_ID, true);
  },

  getClassObject: function(aCompMgr, aCID, aIID)
  {
    if (!aIID.equals(Components.interfaces.nsIFactory))
      throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

    if (aCID.equals(CLASS_ID))
      return ssoautologinFactory;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  canUnload: function(aCompMgr) { return true; }
};

function NSGetModule(aCompMgr, aFileSpec) {
  return ssoautologinModule;
}
